"""
CLI utility to generate local JWT RSA keypair in KAMIWAZA_ROOT/runtime.

Usage:
  python util/generate_jwt_keys.py [optional_target_dir]
"""
import os
import sys
from pathlib import Path
from jwt_keys import generate_jwt_keys


def main() -> int:
    target = None
    if len(sys.argv) > 1:
        target = sys.argv[1]

    if not target:
        root = os.environ.get('KAMIWAZA_ROOT')
        if not root:
            # Fallback: repo root one level up from this file
            root = str(Path(__file__).resolve().parents[1])
        target = os.path.join(root, 'runtime')

    try:
        generate_jwt_keys(target)
        print(f"JWT keypair ensured in {target}")
        return 0
    except Exception as e:
        print(f"Failed to generate JWT keys in {target}: {e}", file=sys.stderr)
        return 1


if __name__ == '__main__':
    raise SystemExit(main())

