import os
os.environ["PROTOCOL_BUFFERS_PYTHON_IMPLEMENTATION"] = "python"

from kamiwaza.services.prompts.setup import setup as psetup
from kamiwaza.services.models.setup import setup as msetup
from kamiwaza.cluster.setup import setup as csetup
from kamiwaza.services.activity.setup import setup as asetup
from kamiwaza.serving.setup import setup as ssetup
from kamiwaza.services.auth.setup import setup as authsetup
from kamiwaza.services.catalog.setup import setup as catalogsetup
from kamiwaza.services.retrieval.setup import setup as retrievalsetup

def reset_all_databases(reset_db: bool = True, skip_confirmation: bool = False) -> None:
    """
    Reset all Kamiwaza databases to initial state.
    This is a destructive operation that will delete all data if reset_db is True.
    
    Args:
        reset_db: Whether to reset the databases. Defaults to True.
        skip_confirmation: Whether to skip the confirmation prompt. Defaults to False.
    """
    print("*** Resetting all databases...")
    
    psetup(reset_db=reset_db)
    msetup(reset_db=reset_db)
    csetup(reset_db=reset_db)
    asetup(reset_db=reset_db)
    ssetup(reset_db=reset_db)
    authsetup(reset_db=reset_db)
    catalogsetup(reset_db=reset_db)
    retrievalsetup(reset_db=reset_db)

    print("*** Database reset complete")

if __name__ == "__main__":
    import sys
    skip_confirmation = "--force" in sys.argv
    
    # Parse reset flag
    reset_db = True
    for arg in sys.argv:
        if arg.startswith("--reset="):
            val = arg.split("=")[1].lower()
            if val in ("0", "false"):
                reset_db = False
                break
    
    # Only prompt for confirmation if we're doing a destructive reset
    if reset_db and not skip_confirmation:
        # Confirm with user before proceeding
        response = input("This will delete ALL data from ALL databases. Are you sure? [y/N] ")
        if response.lower() != 'y':
            print("Database reset cancelled")
            sys.exit(0)
    
    reset_all_databases(reset_db=reset_db, skip_confirmation=skip_confirmation)
