#!/bin/bash

set -ex

cd "$(dirname "${BASH_SOURCE[0]}")"

# Get PIDs of JupyterLab processes
jupyter_pids=$(ps auxwww | grep '[p]ython' | grep jupyter-lab | awk '{print $2}')

# If PIDs were found, kill the processes
if [ ! -z "$jupyter_pids" ]; then
    for pid in $jupyter_pids; do
        echo "Killing JupyterLab process with PID: $pid"
        kill "$pid"
        # Optionally, wait for the process to be killed
        while kill -0 "$pid" 2> /dev/null; do
            echo "Waiting for JupyterLab process PID $pid to terminate..."
            sleep 1
        done
    done
else
    echo "No JupyterLab process found."
fi

