#!/bin/bash

if [ $# -lt 1 ]; then
  echo "Usage: $0 <environment>"
  echo "(The default environment is named default)"
  if [ -n "$KAMIWAZA_ENV" ]; then
    echo "Your current KAMIWAZA_ENV is set to $KAMIWAZA_ENV"
  fi
  exit 1
fi

env_name=$1

# Stop all matching Docker Compose projects
for project in $(docker compose ls --all | grep "kamiwaza" | grep "${env_name}" | awk '{print $1}'); do
    echo "Stopping project: $project"
    docker compose -p "$project" stop
done
