#!/bin/bash
# Get PIDs of kamiwaza Python processes, excluding ray/datahub/etc
# kamiwaza pids, with python
# - Exclude ray
# - Exclude datahub
# - Exclude ms-python (cursor)
# - Exclude grep (this script)
# - Exclude uv (wrapper processes that just wait for children)
# - Only show processes owned by current user
# Note: Using $USER with egrep since we explicitly want to skip containerized
# processes that may be running under the same UID but different usernames

pids=$(ps auxwww | egrep "^${USER}" | grep -i kamiwaza | grep '\.py' | grep python | grep -v kamiwazad | grep -v ray | grep -v ms-python | grep -v grep | grep -v datahub | grep -v ' uv ' | awk '{print $2}')

if [[ -z "${pids:-}" ]]; then
    echo "No kamiwaza processes found"
    exit 0
fi

echo "Found kamiwaza processes: $pids"

# Send SIGTERM once and wait for graceful shutdown
# The process needs time to clean up ephemeral deployments (stop containers)
echo "Sending SIGTERM for graceful shutdown (waiting up to 30s for cleanup)..."
for pid in $pids; do
    if kill -0 "$pid" 2>/dev/null; then
        kill "$pid" 2>/dev/null || true
        echo "  Sent SIGTERM to $pid"
    fi
done

# Wait up to 30 seconds for graceful shutdown, checking every 2 seconds
for i in {1..15}; do
    sleep 2
    pids=$(ps auxwww | egrep "^${USER}" | grep -i kamiwaza | grep '\.py' | grep python | grep -v kamiwazad | grep -v ray | grep -v ms-python | grep -v grep | grep -v datahub | grep -v ' uv ' | awk '{print $2}')
    if [[ -z "${pids:-}" ]]; then
        echo "All processes stopped successfully"
        exit 0
    fi
    echo "  Waiting for shutdown... (${i}/15)"
done

# Force kill any remaining processes
if [[ -n "${pids:-}" ]]; then
    echo "Some processes still running after 30s, sending SIGKILL..."
    for pid in $pids; do
        if kill -0 "$pid" 2>/dev/null; then
            kill -9 "$pid" 2>/dev/null || true
            echo "  Sent SIGKILL to $pid"
        fi
    done
fi
