"""
Startup module for Kamiwaza application.

This module contains initialization scripts and configuration setup
for the Kamiwaza system, including logger setup and telemetry configuration.
"""

# Import key components for easy access
from .secretary_setup import (
    get_logger,
    kamiwaza_logger_instance,
    validate_analytics_url,
    get_version_from_env,
    get_license_info,
    get_telemetry_opt_out,
    get_contact_info,
)

__all__ = [
    'get_logger',
    'kamiwaza_logger_instance', 
    'validate_analytics_url',
    'get_version_from_env',
    'get_license_info',
    'get_telemetry_opt_out',
    'get_contact_info',
] 