#!/bin/bash

force_start=false
env_name=""

for arg in "$@"; do
  if [ "$arg" = "-y" ]; then
    force_start=true
  else
    env_name=$arg
  fi
done

if [ -z "$env_name" ]; then
  echo "Usage: $0 [-y] <environment>"
  if [ -n "$KAMIWAZA_ENV" ]; then
    echo "Your current KAMIWAZA_ENV is set to $KAMIWAZA_ENV"
  fi
  exit 1
fi

# Check for already running projects
running_projects=$(docker compose ls | grep "kamiwaza" | awk '{print $1}')
if [ ! -z "$running_projects" ] && [ "$force_start" = false ]; then
  echo "The following projects are already running and match 'kamiwaza':"
  echo "$running_projects"
  echo "Use '-y' flag to force start all matching projects."
  exit 1
fi

# Start all matching Docker Compose projects
for project in $(docker compose ls --all | grep "kamiwaza" | awk '{print $1}'); do
    echo "Starting project: $project"
    docker compose -p "$project" up -d
done

