#!/bin/bash

set -euxo pipefail

# Set up a full new kamiwaza node as much as we can

# Check if gh is installed, if not, install it
if ! command -v gh &> /dev/null; then
    sudo apt-get install gh
fi

# Check if already logged in to GitHub CLI
if ! gh auth status &> /dev/null; then
    gh auth login
else
    echo "Already logged in to GitHub CLI."
fi


## get pre-req
git clone https://github.com/kamiwaza-ai/kamiwaza-community-edition
cd kamiwaza-community-edition
source 1.sh
source 2.sh

# remove
cd
rm -rf kamiwaza-community-edition

# clone core repos
git clone https://github.com/m9e/kamiwaza-deploy
mv kamiwaza-deploy kamiwaza
cd kamiwaza
git clone https://github.com/m9e/kamiwaza

# mount local disk
cd
bash kamiwaza/mountlocal.sh

if [ -d nvme ] ; then
    mkdir nvme/code
elif [ -d tmp ] ; then
    mkdir tmp/code
else
    echo "No tmp or nvme directory found"
    exit 1
fi



# clone cicd repo
cd
git clone https://github.com/m9e/kamiwaza-cicd

cd kamiwaza-cicd
source 00_env_vars

cd

# Check if /etc/docker/daemon.json exists
# switch docker daemon to use tmp/docker

# Detect the home directory of the non-sudo user
USER_HOME=$(eval echo ~${SUDO_USER:-$USER})

