#!/bin/bash

# modified to handle being sourced so other things
# relying on KAMIWAZA_ROOT can find it
if [ -z "${KAMIWAZA_ROOT:-}" ]; then
    # Detect whether the script is sourced or executed
    if [[ "${BASH_SOURCE[0]}" != "${0}" ]]; then
        # Script is being sourced
        script_dir=$(dirname "${BASH_SOURCE[0]}")
    else
        # Script is being run directly
        script_dir=$(dirname "$0")
    fi

    # Check for launch.py in both possible locations
    if [ -f "$script_dir/launch.py" ]; then
        export KAMIWAZA_ROOT=$(cd "$script_dir" && pwd)
    elif [ -f "$script_dir/kamiwaza/launch.py" ]; then
        export KAMIWAZA_ROOT=$(cd "$script_dir" && pwd)
    fi
fi