#!/bin/bash

EULA_PATH="LICENSE-kamiwaza"
TOTAL_LINES=$(wc -l < "$EULA_PATH")
LINES_PER_PAGE=20
LINES_READ=0

# Display EULA in chunks and check if user reaches the end
echo "Please read the EULA. Press Enter to continue reading."

while [[ $LINES_READ -lt $TOTAL_LINES ]]; do
    # Display 20 lines at a time
    tail -n +"$((LINES_READ + 1))" "$EULA_PATH" | head -n "$LINES_PER_PAGE"
    LINES_READ=$((LINES_READ + LINES_PER_PAGE))
    
    # Prompt the user to continue
    if [[ $LINES_READ -lt $TOTAL_LINES ]]; then
        read -p "Press Enter to continue reading: " answer
    fi
done

# Loop until valid 'yes' or 'no' response is received
while true; do
    read -p "Do you accept the terms in the EULA? (yes/no): " response
    case "$response" in
        yes|y|Y|YES)
            echo "Thank you for accepting the EULA. Proceeding with installation..."
            break
            ;;
        no|n|N|NO)
            echo "You must accept the EULA to proceed."
            exit 1
            ;;
        *)
            echo "Invalid response. Please type 'yes' or 'no'."
            ;;
    esac
done
