#!/usr/bin/env bash
set -euo pipefail

SCRIPT_DIR="$(cd -- "$(dirname -- "${BASH_SOURCE[0]}" )" &>/dev/null && pwd)"
PROJECT_ROOT="${SCRIPT_DIR}"
cd "${PROJECT_ROOT}" >/dev/null 2>&1 || {
  echo "Failed to change directory to ${PROJECT_ROOT}" >&2
  exit 1
}

UV_BIN="${UV_BIN:-}"
if [[ -z "${UV_BIN}" ]]; then
  if command -v uv >/dev/null 2>&1; then
    UV_BIN="$(command -v uv)"
  elif [[ -n "${KAMIWAZA_ROOT:-}" && -x "${KAMIWAZA_ROOT}/uv" ]]; then
    UV_BIN="${KAMIWAZA_ROOT}/uv"
  elif [[ -x "${PROJECT_ROOT}/uv" ]]; then
    UV_BIN="${PROJECT_ROOT}/uv"
  elif [[ -x "/opt/kamiwaza/kamiwaza/uv" ]]; then
    UV_BIN="/opt/kamiwaza/kamiwaza/uv"
  fi
fi

if [[ -z "${UV_BIN}" ]]; then
  echo "uv is required but was not found on PATH or bundled locations. Install uv or set UV_BIN." >&2
  exit 1
fi

"${UV_BIN}" --project "$PROJECT_ROOT" run --frozen -- ray "$@"
