#!/bin/bash
set -e

# Determine the directory where this script is located
SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"

# Set KAMIWAZA_ROOT if not already set
export KAMIWAZA_ROOT="${KAMIWAZA_ROOT:-$SCRIPT_DIR}"

# Source env.sh to load environment variables
if [ -f "/etc/kamiwaza/env.sh" ]; then
    source "/etc/kamiwaza/env.sh"
elif [ -f "${KAMIWAZA_ROOT}/env.sh" ]; then
    source "${KAMIWAZA_ROOT}/env.sh"
else
    echo "Warning: env.sh not found in /etc/kamiwaza or ${KAMIWAZA_ROOT}" >&2
fi

# Run the bridge script using uv if available, or .venv python, otherwise fail
if command -v uv >/dev/null 2>&1; then
    exec uv run --frozen python3 "${SCRIPT_DIR}/kamiwaza_mcp_bridge.py" "$@"
elif [ -f "${KAMIWAZA_ROOT}/.venv/bin/python" ]; then
    exec "${KAMIWAZA_ROOT}/.venv/bin/python" "${SCRIPT_DIR}/kamiwaza_mcp_bridge.py" "$@"
else
    echo "Error: Neither 'uv' command nor '.venv/bin/python' found. Cannot run bridge." >&2
    exit 1
fi
