#!/usr/bin/env python3

import yaml
import sys

def flatten_dict(d, parent_key='', sep='/'):
    items = []
    for k, v in d.items():
        new_key = f"{parent_key}{sep}{k}" if parent_key else k
        if isinstance(v, dict):
            items.extend(flatten_dict(v, new_key, sep=sep).items())
        elif isinstance(v, list):
            for i, item in enumerate(v):
                items.extend(flatten_dict({str(i): item}, new_key, sep=sep).items())
        else:
            items.append((new_key, v))
    return dict(items)

def generate_etcd_commands(data):
    flat_data = flatten_dict(data)
    for key, value in flat_data.items():
        # Convert value to string without adding extra quotes
        value_str = str(value)
        print(f'{key} {value_str}')

if __name__ == "__main__":
    if len(sys.argv) != 2:
        print(f"Usage: {sys.argv[0]} <traefik-dynamic.yml>")
        sys.exit(1)

    yaml_file = sys.argv[1]
    
    with open(yaml_file, 'r') as file:
        try:
            data = yaml.safe_load(file)
            generate_etcd_commands(data)
        except yaml.YAMLError as e:
            print(f"Error parsing YAML file: {e}", file=sys.stderr)
            sys.exit(1)