#!/bin/bash
# Prelaunch script for OTEL Collector
# Creates necessary log directories before container startup

set -euo pipefail

# Determine log directory using Kamiwaza's strategy
get_log_directory() {
    # First check if KAMIWAZA_LOG_DIR is already set and writable
    if [[ -n "${KAMIWAZA_LOG_DIR:-}" ]]; then
        if [[ -w "$KAMIWAZA_LOG_DIR" ]] || mkdir -p "$KAMIWAZA_LOG_DIR" 2>/dev/null; then
            echo "$KAMIWAZA_LOG_DIR"
            return 0
        fi
    fi

    # Fallback strategy
    local fallback_dirs=("/opt/kamiwaza/logs" "/var/log" "/tmp")

    for log_dir in "${fallback_dirs[@]}"; do
        if [[ -w "$log_dir" ]] || mkdir -p "$log_dir" 2>/dev/null; then
            echo "$log_dir"
            return 0
        fi
    done

    echo "/tmp"  # Final fallback
}

# Get or set KAMIWAZA_LOG_DIR
if [[ -z "${KAMIWAZA_LOG_DIR:-}" ]]; then
    export KAMIWAZA_LOG_DIR=$(get_log_directory)
fi

# Create OTEL and application log directories
# These map to /tmp in the container via volume mount
# All logs go directly under logs/ (not logs/kamiwaza/)
mkdir -p "$KAMIWAZA_LOG_DIR/traefik" 2>/dev/null || true
mkdir -p "$KAMIWAZA_LOG_DIR/etcd" 2>/dev/null || true
mkdir -p "$KAMIWAZA_LOG_DIR/otel" 2>/dev/null || true

echo "[OTEL Prelaunch] Created log directories in $KAMIWAZA_LOG_DIR"
