#!/bin/bash

# Common logging functions for deployment scripts
# Each script should set LOG_PREFIX before sourcing this file

# Function to print messages with component-specific prefix
log_info() {
    echo "[${LOG_PREFIX:-INFO}] $1"
}

log_warn() {
    echo "[${LOG_PREFIX:-WARN}] $1"
}

log_error() {
    echo "[${LOG_PREFIX:-ERROR}] $1"
}

log_success() {
    echo "[${LOG_PREFIX:-SUCCESS}] $1"
}

log_step() {
    echo ""
    echo "=========================================="
    echo "${LOG_PREFIX:-STEP}: $1"
    echo "=========================================="
}

# Function to log command execution
log_cmd() {
    log_info "Executing: $*"
    "$@"
}

# Function to check command success with custom error message
check_success() {
    if [ $? -ne 0 ]; then
        log_error "$1"
        return 1
    fi
    return 0
}