#!/bin/bash

log_info() {
    echo "[INFO] $1"
}

if [ -z "$KAMIWAZA_ENV" ]; then
    log_error "KAMIWAZA_ENV is not set"
    exit 1
fi

log_info "Starting containers for quickstart..."
if ! docker compose -f "docker-compose.yml" -p "${KAMIWAZA_ENV}-${component}" --profile quickstart up -d; then
    log_error "Failed to start containers for quickstart"
    exit 1
fi
log_success "Containers started successfully for quickstart"