#!/bin/bash
set -euo pipefail

# Set component-specific log prefix
LOG_PREFIX="COCKROACHDB-POSTLAUNCH"

# Source the common logging functions
if [ -f "./common-logging.sh" ]; then
    source ./common-logging.sh
else
    # Fallback if common-logging.sh not found
    log_info() { echo "[INFO] $1"; }
    log_warn() { echo "[WARN] $1"; }
    log_error() { echo "[ERROR] $1"; }
    log_success() { echo "[SUCCESS] $1"; }
    log_step() { echo ""; echo "========== $1 =========="; }
fi

log_step "Configuring CockroachDB users and permissions"

# Define your variables
DIRECTORY_TARGET="."                # By default we assume this will run in the deployment directory and certs will be there
CERTS_DIR="certs"                   # Directory containing your certs
HOST="localhost"                    # Host where CockroachDB is running
NEW_ROOT_PASSWORD="kamiwazaGetY0urCape"    # New password for the root user
POSTGRES_PASSWORD="kamiwazaGetY0urCape"    # Password for the postgres user

# Change to the CockroachDB directory if needed
if [ -n "${COCKROACH_DIR:-}" ]; then
    cd "$COCKROACH_DIR"
fi

# Change root password
log_info "Setting root user password..."
echo "ALTER USER root WITH PASSWORD '${NEW_ROOT_PASSWORD}';" | \
cockroach sql --certs-dir="$CERTS_DIR" --host="$HOST"
if [ $? -eq 0 ]; then
    log_success "Root user password updated"
else
    log_error "Failed to update root user password"
    exit 1
fi

# Add postgres user and change password
log_info "Creating postgres user and setting password..."
echo "CREATE USER IF NOT EXISTS postgres; ALTER USER postgres WITH PASSWORD '${POSTGRES_PASSWORD}';" | \
cockroach sql --certs-dir="$CERTS_DIR" --host="$HOST"
if [ $? -eq 0 ]; then
    log_success "Postgres user configured"
else
    log_error "Failed to configure postgres user"
    exit 1
fi

# Grant permissions to postgres user
log_info "Granting permissions to postgres user..."
echo "GRANT ALL ON DATABASE postgres TO postgres; GRANT ALL ON ALL TABLES IN SCHEMA public TO postgres; ALTER DEFAULT PRIVILEGES IN SCHEMA public GRANT ALL ON TABLES TO postgres;" | \
cockroach sql --certs-dir="$CERTS_DIR" --host="$HOST"
if [ $? -eq 0 ]; then
    log_success "Permissions granted to postgres user"
else
    log_error "Failed to grant permissions to postgres user"
    exit 1
fi

log_success "CockroachDB user configuration completed"
