// frontend/src/utils/api.js
import axios from 'axios';
import { BASE_URL } from '../const';
import { getSessionAuthToken } from './sessionToken';

const api = axios.create({
  baseURL: BASE_URL,
  withCredentials: true, // Send cookies with all requests
});

api.interceptors.request.use(
  (config) => {
    const token = getSessionAuthToken();
    if (token) {
      if (!config.headers) {
        config.headers = {};
      }
      config.headers['Authorization'] = `Bearer ${token}`;
    }
    return config;
  },
  (error) => Promise.reject(error)
);

export default api;
