import axios from 'axios';

import { BASE_URL } from '../const';

/**
 * Get container logs for a specific deployment
 * @param {string} deploymentId - The deployment ID
 * @returns {Promise} Response containing logs and metadata
 */
export const getDeploymentLogs = async (deploymentId) => {
  try {
    const response = await axios.get(`${BASE_URL}/serving/deployment/${deploymentId}/logs`);
    return response.data;
  } catch (error) {
    console.error(`Error retrieving logs for deployment ${deploymentId}:`, error);
    throw error;
  }
};

/**
 * Analyze deployment logs for failure patterns
 * @param {string} deploymentId - The deployment ID
 * @returns {Promise} Response containing pattern analysis
 */
export const getDeploymentLogPatterns = async (deploymentId) => {
  try {
    const response = await axios.get(`${BASE_URL}/serving/deployment/${deploymentId}/logs/patterns`);
    return response.data;
  } catch (error) {
    console.error(`Error analyzing log patterns for deployment ${deploymentId}:`, error);
    throw error;
  }
};

/**
 * List available logs for a specific engine type
 * @param {string} engineType - The engine type (vllm, llamacpp, etc.)
 * @returns {Promise} Response containing list of available logs
 */
export const listEngineLogs = async (engineType) => {
  try {
    const response = await axios.get(`${BASE_URL}/serving/logs/${engineType}`);
    return response.data;
  } catch (error) {
    console.error(`Error listing logs for engine ${engineType}:`, error);
    throw error;
  }
};