import axios from 'axios';

// Replace with your actual API base URL
import { BASE_URL } from '../const';

export const listModels = async () => {
  try {
    const response = await axios.get(`${BASE_URL}/models/`);
    return response.data;
  } catch (error) {
    console.error('There was an error listing the models!', error);
    throw error;
  }
};

export const getModelById = async (modelId) => {
  try {
    const response = await axios.get(`${BASE_URL}/models/${modelId}`);
    return response.data;
  } catch (error) {
    console.error(`There was an error retrieving model ${modelId}!`, error);
    throw error;
  }
};

export const createModel = async (modelData) => {
  try {
    const response = await axios.post(`${BASE_URL}/models/`, modelData);
    return response.data;
  } catch (error) {
    console.error('There was an error creating the model!', error);
    throw error;
  }
};

export const searchModels = async (searchQuery) => {
  try {
    const response = await axios.post(`${BASE_URL}/models/search/`, { query: searchQuery });
    return response.data;
  } catch (error) {
    console.error('There was an error searching for models!', error);
    throw error;
  }
};
