import { useContext } from 'react';
import { AuthContext } from '../context/AuthContext';

/**
 * Hook to check if the current user has admin role.
 * @returns {boolean} True if user has 'admin' role, false otherwise
 */
export const useIsAdmin = () => {
  const { user } = useContext(AuthContext);
  return user && Array.isArray(user.roles) && user.roles.includes('admin');
};

export default useIsAdmin;
