// Dynamically construct the API URL based on the current host
export const API_PORT = '7777'; // API port
export const LAB_PORT = '8888';

export const isDefaultPort = (port) => port === '' || port === '80' || port === '443';

const currentPort = window.location.port;

// We now use the prefixes consistently whether going through traefik or not
// no longer using stripPrefix middleware; so if you are coming through
// (we think) traefik, we let traefik handle the other URIs; if you are
// not (probably dev but perhaps diagnostically) we append the service ports
// TODO: config rather than code in case someone has a use case to change the listener
// ports for fastapi and jupyterlab
const basePath = isDefaultPort(currentPort) ? '/api' : `:${API_PORT}/api`;
const labPath = isDefaultPort(currentPort) ? '/lab' : `:${LAB_PORT}/lab`;

export const BASE_URL = `${window.location.protocol}//${window.location.hostname}${basePath}`;
export const LAB_URL = `${window.location.protocol}//${window.location.hostname}${labPath}`;
export const NEWS_API_URL = 'https://info.kamiwaza.ai';
