# Garden Components - Unified Template Management

This directory contains the unified template management system for Kamiwaza, which provides a single interface for managing both application and tool templates.

## Components

### UnifiedTemplateManager.js
The main component that provides a unified interface for template management. Features include:

- **Tabbed Interface**: Switch between Apps and Tools templates
- **Remote Status Monitoring**: Real-time status of available updates and new templates
- **Batch Operations**: Import new templates and update all templates at once
- **Individual Template Management**: Update and delete individual templates
- **Deployment Management**: View active deployments and show/hide stopped deployments
- **Conflict Resolution**: Handles active deployment conflicts when updating/deleting templates

## Key Features

### Remote Template Synchronization
- **Caching**: Templates are cached locally for 4 hours to reduce network requests
- **Import-Only**: Only imports new templates, preserving user customizations
- **Version Checking**: Compares local and remote versions to show available updates
- **Selective Updates**: Users can update individual templates or all at once

### Deployment Safety
- **Active Deployment Protection**: Prevents template deletion/updates when deployments are running
- **Automatic Cleanup**: Removes stopped deployments when deleting templates
- **Conflict Dialog**: Shows which deployments are blocking template operations

### Enhanced Template Cards
Both `AppTemplateCard` and `ToolTemplateCard` have been enhanced with:
- **Deployment Status**: Shows number of active deployments
- **Update Indicators**: Visual badges when updates are available
- **Action Menu**: Three-dot menu for update/delete actions
- **Error Handling**: Proper error display and user feedback

## API Integration

The component integrates with the new unified template management API:
- `GET /garden/apps/remote/status` - Get app template status
- `GET /garden/tool/remote/status` - Get tool template status  
- `POST /garden/apps/remote/sync` - Import new app templates
- `POST /garden/tool/remote/sync` - Import new tool templates
- `PUT /garden/apps/app_templates/{id}` - Update individual templates
- `DELETE /garden/apps/app_templates/{id}` - Delete templates with cleanup

## Usage

The unified template manager is accessible via:
- **URL**: `/templates`
- **Navigation**: "Template Manager" in the sidebar
- **Icon**: ManageAccounts icon

## Migration Notes

This system replaces the separate template management scattered across:
- App Garden (`/apps`) - still functional for deployment-focused workflow
- Tool Shed (`/tool-shed`) - still functional for tool-specific deployment
- New unified view (`/templates`) - comprehensive template lifecycle management

Users can continue using the existing App Garden and Tool Shed for deployments, while using the Template Manager for template lifecycle operations.