import React from 'react';
import { renderWithTheme } from '../../../test-utils';
import Spinner from '../Spinner';

describe('Spinner Component', () => {
  test('renders without crashing', () => {
    renderWithTheme(<Spinner />);
  });

  test('displays loading indicator for users', () => {
    const { getByRole } = renderWithTheme(<Spinner />);
    
    // Test what users actually experience - a loading indicator
    const loadingIndicator = getByRole('progressbar');
    expect(loadingIndicator).toBeInTheDocument();
  });

  test('loading indicator is properly centered and visible', () => {
    const { getByRole } = renderWithTheme(<Spinner />);
    
    // Verify the loading indicator is accessible and present
    const loadingIndicator = getByRole('progressbar');
    expect(loadingIndicator).toBeVisible();
  });
});