import React, { useEffect } from 'react';
import { StyledConfirmModal, StyledModalContent, StyledButton } from '../../StyledComponents';
import Typography from '@mui/material/Typography';
import Box from '@mui/material/Box';
import { StyledIconButton } from '../../StyledComponents';
import CloseIcon from '@mui/icons-material/Close';

const ConfirmModal = ({ title, message, onConfirm, onCancel, showModal }) => {
    // Add event listener for escape key
    useEffect(() => {
        const handleEsc = (event) => {
            if (event.keyCode === 27) onCancel();
        };
        window.addEventListener('keydown', handleEsc);

        // Remove event listener on cleanup
        return () => {
            window.removeEventListener('keydown', handleEsc);
        };
    }, [onCancel]);

    return (
        <>
            <StyledConfirmModal
                open={showModal}
                onCancel={onCancel}
            >
                <StyledModalContent>
                    <Box className="confirm-modal"
                        sx={{
                            margin: 2, // Add some margin around the content
                            padding: 2, // Add some padding inside the box for spacing
                            border: '1px solid grey', // Add a border for visual separation
                            boxShadow: 10,
                            borderRadius: '4px', // Optional: round the corners of the modal
                        }}
                    >
                        <StyledIconButton
                            aria-label="close"
                            onClick={onCancel}
                        >
                            <CloseIcon />
                        </StyledIconButton>
                        <Typography variant="h6" component="h2">
                            {title}
                        </Typography>
                        <p>{message}</p>
                        <StyledButton variant="contained" color="primary" onClick={onConfirm}>
                            Yes
                        </StyledButton>
                        <StyledButton variant="outlined" color="secondary" onClick={onCancel}>
                            No
                        </StyledButton>
                    </Box>
                </StyledModalContent>
            </StyledConfirmModal>
        </>
    );
};

export default ConfirmModal;
