# App Garden Implementation TODO

## Architecture Overview
The App Garden will be a new feature that allows users to browse, preview, and deploy containerized applications from templates. It will follow the same design patterns as the Models section but adapted for app deployments.

## Component Structure
```
frontend/src/components/apps/
├── AppGarden.js              # Main container component (like ModelIndex.js)
├── AppTemplateList.js        # Grid/card view of available app templates
├── AppTemplateCard.js        # Individual app template card with preview
├── AppDeploymentList.js      # List of deployed apps (similar to ModelDeploymentList.js)
├── AppDeploymentDetail.js    # Detailed view of a deployed app
├── AppDeployModal.js         # Modal for deploying an app from template
├── AppPreviewModal.js        # Modal to show larger preview/screenshots
└── TODO.md                   # This file
```

## Tasks

### Phase 1: Core Components Setup
- [x] Create AppGarden.js main component
- [x] Add route to App.js for /apps
- [x] Add "App Garden" to Sidebar navigation
- [x] Create AppTemplateList.js with grid layout
- [x] Create AppTemplateCard.js with:
  - [x] App name and version
  - [x] Thumbnail image (with fallback)
  - [x] Brief description
  - [x] Deploy button
  - [x] Preview button

### Phase 2: API Integration
- [x] Create API service functions for:
  - [x] Fetching app templates
  - [x] Deploying apps
  - [x] Listing deployments
  - [x] Getting deployment details
  - [x] Stopping deployments
- [x] Integrate with existing axios patterns

### Phase 3: Deployment Features
- [x] Create AppDeployModal.js for deployment configuration
- [x] Create AppDeploymentList.js to show running apps
- [x] Create AppDeploymentDetail.js for detailed view
- [x] Add status indicators (running, stopped, failed)
- [x] Add port mapping display
- [x] Add "Open App" buttons with proper URLs

### Phase 4: Preview & Polish
- [x] Create AppPreviewModal.js for larger screenshots
- [x] Add thumbnail/screenshot support with fallbacks
- [x] Implement beautiful fallback UI for apps without images
- [x] Add loading states and error handling
- [x] Apply consistent styling with existing theme

### Phase 5: Advanced Features (Future)
- [ ] Add search/filter functionality
- [ ] Add app categories/tags
- [ ] Add resource usage indicators
- [ ] Add deployment history
- [ ] Add app logs viewer (future)

## Design Notes
- Follow the existing color scheme (primary: #00c07f)
- Use similar table/card patterns as Models section
- Ensure responsive design for different screen sizes
- Use Material-UI components consistently
- Add tooltips for better UX

## API Endpoints to Use
- GET /api/apps/app_templates - List all templates
- POST /api/apps/deploy_app - Deploy new app
- GET /api/apps/deployments - List deployments
- GET /api/apps/deployment/{id} - Get deployment details
- DELETE /api/apps/deployment/{id} - Stop deployment
- GET /api/apps/instances - List instances

## Sample App Template Structure
```json
{
  "name": "hello-web-template",
  "version": "1.0.0",
  "source_type": "user_repo",
  "visibility": "private",
  "compose_yml": "...",
  "risk_tier": 0,
  "thumbnail_url": "/static/app-thumbnails/hello-web.png",
  "screenshot_url": "/static/app-screenshots/hello-web.png",
  "description": "A simple hello world web application",
  "tags": ["web", "demo", "nginx"]
}
```

## Implementation Complete! 🎉

The App Garden feature has been successfully implemented with:
- Beautiful card-based UI for app templates
- Deployment functionality with configuration options
- Real-time deployment status tracking
- Port mapping and instance management
- Preview functionality with fallback designs
- Consistent styling with the existing Kamiwaza theme

The implementation follows the same patterns as the Models section while being adapted for containerized applications. 