import React from 'react';
import { render } from '@testing-library/react';
import App from '../App';

// Silence console errors in tests
const originalError = console.error;
beforeAll(() => {
  console.error = jest.fn();
});
afterAll(() => {
  console.error = originalError;
});

// Mock axios globally
jest.mock('axios', () => {
  const mockAxios = {
    get: jest.fn(() => Promise.resolve({ data: {} })),
    post: jest.fn(() => Promise.resolve({ data: {} })),
    put: jest.fn(() => Promise.resolve({ data: {} })),
    delete: jest.fn(() => Promise.resolve({ data: {} })),
    interceptors: {
      request: { use: jest.fn() },
      response: { use: jest.fn() }
    }
  };
  return {
    __esModule: true,
    default: {
      create: jest.fn(() => mockAxios)
    },
    create: jest.fn(() => mockAxios)
  };
});

// Mock js-cookie
jest.mock('js-cookie', () => {
  const mockCookies = {
    get: jest.fn(),
    set: jest.fn(),
    remove: jest.fn()
  };
  return {
    __esModule: true,
    default: mockCookies,
    ...mockCookies
  };
});

// Mock react-markdown
jest.mock('react-markdown', () => {
  const React = require('react');
  return function MockReactMarkdown({ children }) {
    return React.createElement('div', null, children);
  };
});

// Mock the ModelFilesContext
jest.mock('../components/models/ModelFilesContext', () => {
  const React = require('react');
  const mockContextValue = {
    statusModelFiles: [],
    updateStatusModelFiles: jest.fn(),
    clearCompletedDownloads: jest.fn(),
    cancelDownload: jest.fn(),
    cancelAllDownloads: jest.fn(),
    showDownloadStatus: false,
    setShowDownloadStatus: jest.fn(),
    toast: { open: false, message: '', severity: 'info' },
    showToast: jest.fn(),
    closeToast: jest.fn(),
    refreshModelList: jest.fn(),
    modelListRefreshTrigger: 0,
    startPolling: jest.fn(),
    hasActiveDownloads: false,
  };
  
  const ModelFilesContext = React.createContext(mockContextValue);
  
  return {
    __esModule: true,
    default: ModelFilesContext,
    ModelFilesProvider: ({ children }) => (
      React.createElement(ModelFilesContext.Provider, { value: mockContextValue }, children)
    ),
    useModelFiles: () => mockContextValue
  };
});

// Mock window.location properly
Object.defineProperty(window, 'location', {
  writable: true,
  value: {
    href: 'http://localhost:3000/',
    origin: 'http://localhost:3000',
    protocol: 'http:',
    host: 'localhost:3000',
    hostname: 'localhost',
    port: '3000',
    pathname: '/',
    search: '',
    hash: '',
    assign: jest.fn(),
    reload: jest.fn(),
    replace: jest.fn()
  }
});

// Mock IntersectionObserver
global.IntersectionObserver = class IntersectionObserver {
  constructor() {}
  disconnect() {}
  observe() {}
  unobserve() {}
};

// Mock fetch
global.fetch = jest.fn(() =>
  Promise.resolve({
    ok: true,
    json: () => Promise.resolve({ hardware: [{ os: 'linux' }] }),
  })
);

describe('App Startup Test', () => {
  beforeEach(() => {
    // Clear all mocks
    jest.clearAllMocks();
  });

  test('app renders without crashing', () => {
    render(<App />);
    expect(document.querySelector('#root')).toBeInTheDocument();
  });
});