import { createTheme } from '@mui/material/styles';

const baseSpacing = 8;

const theme = createTheme({
  palette: {
    mode: 'dark',
    primary: {
      main: '#00c07f', // Modern teal/green
      light: '#33cfb5',
      dark: '#008c5a',
      contrastText: '#fff',
    },
    secondary: {
      main: '#1e88e5', // Modern blue
      light: '#4b9fea',
      dark: '#1565c0',
      contrastText: '#fff',
    },
    background: {
      default: '#121212', // Dark background
      paper: '#1e1e1e', // Slightly lighter dark for cards/elements
    },
    text: {
      primary: '#ffffff',
      secondary: '#b0b0b0',
    },
    accent: {
      main: '#00c07f',
      light: '#33d69b',
      dark: '#00a166',
    },
    error: {
      main: '#f44336',
      light: '#e57373',
      dark: '#d32f2f',
      contrastText: '#fff',
    },
    warning: {
      main: '#ff9800',
      light: '#ffb74d',
      dark: '#f57c00',
      contrastText: '#fff',
    },
    info: {
      main: '#29b6f6',
      light: '#4fc3f7',
      dark: '#0288d1',
      contrastText: '#fff',
    },
    success: {
      main: '#00c07f',
      light: '#33d69b',
      dark: '#00a166',
      contrastText: '#fff',
    },
    divider: '#2d2d2d',
  },
  typography: {
    fontFamily: ['Montserrat', 'Nunito', 'Segoe UI', 'Inter', 'Arial', 'sans-serif'].join(','),
    h1: {
      fontSize: '2rem', // 32px - Enterprise standard (Material Design, IBM Carbon)
      fontWeight: 700,
      lineHeight: 1.2,
      letterSpacing: '-0.01562em',
      '@media (max-width:600px)': {
        fontSize: '1.75rem',
      },
    },
    h2: {
      fontSize: '1.5rem', // 24px - Enterprise standard
      fontWeight: 600,
      lineHeight: 1.3,
      letterSpacing: '-0.00833em',
      '@media (max-width:600px)': {
        fontSize: '1.25rem',
      },
    },
    h3: {
      fontSize: '1.25rem', // 20px - Enterprise standard
      fontWeight: 500,
      lineHeight: 1.4,
      letterSpacing: '0em',
      '@media (max-width:600px)': {
        fontSize: '1.125rem',
      },
    },
    h4: {
      fontSize: '1.125rem', // 18px
      fontWeight: 500,
      lineHeight: 1.4,
    },
    h5: {
      fontSize: '1rem', // 16px
      fontWeight: 500,
      lineHeight: 1.5,
    },
    h6: {
      fontSize: '0.875rem', // 14px
      fontWeight: 500,
      lineHeight: 1.5,
    },
    body1: {
      fontSize: '0.875rem', // 14px - Enterprise standard (Material Design, Ant Design)
      fontWeight: 400,
      lineHeight: 1.5,
      letterSpacing: '0.00938em',
    },
    body2: {
      fontSize: '0.75rem', // 12px - For secondary/helper text
      fontWeight: 400,
      lineHeight: 1.43,
      letterSpacing: '0.01071em',
    },
    caption: {
      fontSize: '0.75rem', // 12px - For captions and labels
      fontWeight: 400,
      lineHeight: 1.66,
      letterSpacing: '0.03333em',
    },
    button: {
      textTransform: 'none',
      fontWeight: 500,
      fontSize: '0.875rem', // 14px - Enterprise standard for buttons
      letterSpacing: '0.02857em',
    },
  },
  components: {
    MuiCssBaseline: {
      styleOverrides: {
        body: {
          scrollbarWidth: 'thin',
          '&::-webkit-scrollbar': {
            width: '8px',
            height: '8px',
          },
          '&::-webkit-scrollbar-track': {
            background: '#1e1e1e',
          },
          '&::-webkit-scrollbar-thumb': {
            backgroundColor: '#555555',
            borderRadius: '4px',
          },
          '&::-webkit-scrollbar-thumb:hover': {
            backgroundColor: '#777777',
          },
        },
      },
    },
    MuiPaper: {
      styleOverrides: {
        root: {
          backgroundImage: 'none',
        },
      },
    },
    MuiButton: {
      styleOverrides: {
        root: {
          borderRadius: 8,
          padding: '6px 14px', // Reduced from 8px 16px - Enterprise standard
          boxShadow: 'none', // Remove default shadow for cleaner look
          marginLeft: 0, // Remove default margins
          marginRight: 0,
          transition: 'all 0.2s ease',
          '&:hover': {
            boxShadow: '0 2px 4px rgba(0, 0, 0, 0.1)',
            transform: 'translateY(-1px)',
          },
        },
        sizeSmall: {
          padding: '4px 10px',
          fontSize: '0.8125rem', // 13px
        },
        sizeLarge: {
          padding: '8px 20px',
          fontSize: '0.9375rem', // 15px
        },
      },
    },
    MuiTextField: {
      styleOverrides: {
        root: {
          margin: '8px',
          '& .MuiOutlinedInput-root': {
            '& fieldset': {
              borderColor: 'rgba(255, 255, 255, 0.23)',
            },
            '&:hover fieldset': {
              borderColor: 'rgba(255, 255, 255, 0.5)',
            },
            '&.Mui-focused fieldset': {
              borderColor: '#00c07f',
            },
          },
        },
      },
    },
    MuiCheckbox: {
      styleOverrides: {
        root: {
          color: '#00c07f',
          '&.Mui-checked': {
            color: '#00c07f',
          },
        },
      },
    },
    MuiIconButton: {
      styleOverrides: {
        root: {
          padding: '8px', // Reduced from 10px
          '&:hover': {
            backgroundColor: 'rgba(255, 255, 255, 0.08)',
          },
        },
      },
    },
    MuiModal: {
      styleOverrides: {
        paper: {
          backgroundColor: '#1e1e1e',
          boxShadow: '0 8px 16px rgba(0, 0, 0, 0.5)',
          borderRadius: '8px',
        },
      },
    },
    MuiCircularProgress: {
      styleOverrides: {
        root: {
          color: '#00c07f',
        },
      },
    },
    MuiTableHead: {
      styleOverrides: {
        root: {
          backgroundColor: '#1a1a1a',
        },
      },
    },
    MuiTableRow: {
      styleOverrides: {
        root: {
          '&:nth-of-type(odd)': {
            backgroundColor: 'rgba(255, 255, 255, 0.03)',
          },
          '&:hover': {
            backgroundColor: 'rgba(255, 255, 255, 0.08)',
          },
        },
      },
    },
    MuiTableBody: {
      styleOverrides: {
        root: {
          '& .MuiTableCell-body': {
            color: '#b0b0b0',
          },
        },
      },
    },
    MuiTableCell: {
      styleOverrides: {
        head: {
          fontWeight: 700,
          color: '#ffffff',
        },
        body: {
          fontWeight: 400,
          borderBottom: '1px solid #2d2d2d',
        },
        root: {
          padding: '10px 14px', // Reduced from 12px 16px for better density
        },
        sizeSmall: {
          padding: '6px 14px',
        },
      },
    },
    MuiChip: {
      styleOverrides: {
        root: {
          backgroundColor: 'rgba(0, 192, 127, 0.15)',
          '&.MuiChip-colorPrimary': {
            backgroundColor: 'rgba(0, 192, 127, 0.2)',
          },
        },
        label: {
          color: '#ffffff',
        },
      },
    },
    MuiCard: {
      styleOverrides: {
        root: {
          backgroundColor: '#1e1e1e',
          borderRadius: '12px',
          boxShadow: '0 8px 16px rgba(0, 0, 0, 0.2)',
          overflow: 'hidden',
          transition: 'transform 0.3s ease, box-shadow 0.3s ease',
          '&:hover': {
            transform: 'translateY(-4px)',
            boxShadow: '0 12px 20px rgba(0, 0, 0, 0.3)',
          },
        },
      },
    },
    MuiCardHeader: {
      styleOverrides: {
        root: {
          padding: '12px 16px', // Reduced from 16px 24px
        },
        title: {
          fontSize: '1.125rem', // Reduced from 1.25rem
          fontWeight: 600,
        },
      },
    },
    MuiCardContent: {
      styleOverrides: {
        root: {
          padding: '16px', // Reduced from 24px
          '&:last-child': {
            paddingBottom: '16px',
          },
        },
      },
    },
    MuiAppBar: {
      styleOverrides: {
        root: {
          boxShadow: '0 4px 12px rgba(0, 0, 0, 0.3)',
          backgroundImage: 'none',
        },
      },
    },
    MuiDrawer: {
      styleOverrides: {
        paper: {
          backgroundColor: '#1a1a1a',
          borderRight: '1px solid #2d2d2d',
          boxShadow: '4px 0 8px rgba(0, 0, 0, 0.2)',
        },
      },
    },
    MuiListItem: {
      styleOverrides: {
        root: {
          paddingTop: '8px', // Reduced from 12px
          paddingBottom: '8px',
          '&.Mui-selected': {
            backgroundColor: 'rgba(0, 192, 127, 0.15)',
            '&:hover': {
              backgroundColor: 'rgba(0, 192, 127, 0.25)',
            },
          },
          '&:hover': {
            backgroundColor: 'rgba(255, 255, 255, 0.08)',
          },
        },
      },
    },
  },
  spacing: baseSpacing,
  shape: {
    borderRadius: 8,
  },
  shadows: [
    'none',
    '0px 2px 4px rgba(0, 0, 0, 0.2)',
    '0px 4px 6px rgba(0, 0, 0, 0.25)',
    '0px 6px 12px rgba(0, 0, 0, 0.3)',
    '0px 8px 16px rgba(0, 0, 0, 0.3)',
    '0px 10px 20px rgba(0, 0, 0, 0.35)',
    '0px 12px 24px rgba(0, 0, 0, 0.4)',
    '0px 14px 28px rgba(0, 0, 0, 0.45)',
    '0px 16px 32px rgba(0, 0, 0, 0.5)',
    '0px 18px 36px rgba(0, 0, 0, 0.55)',
    '0px 20px 40px rgba(0, 0, 0, 0.6)',
    '0px 22px 44px rgba(0, 0, 0, 0.65)',
    '0px 24px 48px rgba(0, 0, 0, 0.7)',
    '0px 26px 52px rgba(0, 0, 0, 0.75)',
    '0px 28px 56px rgba(0, 0, 0, 0.8)',
    '0px 30px 60px rgba(0, 0, 0, 0.85)',
    '0px 32px 64px rgba(0, 0, 0, 0.9)',
    '0px 34px 68px rgba(0, 0, 0, 0.95)',
    '0px 36px 72px rgba(0, 0, 0, 1.0)',
    '0px 38px 76px rgba(0, 0, 0, 1.0)',
    '0px 40px 80px rgba(0, 0, 0, 1.0)',
    '0px 42px 84px rgba(0, 0, 0, 1.0)',
    '0px 44px 88px rgba(0, 0, 0, 1.0)',
    '0px 46px 92px rgba(0, 0, 0, 1.0)',
    '0px 48px 96px rgba(0, 0, 0, 1.0)',
  ],
});

export default theme;
