import React from 'react';
import { styled } from '@mui/material/styles';
import Table from '@mui/material/Table';
import TableHead from '@mui/material/TableHead';
import TableRow from '@mui/material/TableRow';
import TableCell from '@mui/material/TableCell';
import TableBody from '@mui/material/TableBody';
import Button from '@mui/material/Button';
import IconButton from '@mui/material/IconButton';
import Checkbox from '@mui/material/Checkbox';
import FormControlLabel from '@mui/material/FormControlLabel';
import Box from '@mui/material/Box';
import Modal from '@mui/material/Modal';
import CircularProgress from '@mui/material/CircularProgress';
import Slider from '@mui/material/Slider';
import Switch from '@mui/material/Switch';
import TextField from '@mui/material/TextField';
import LinearProgress from '@mui/material/LinearProgress';
import Typography from '@mui/material/Typography';
import CloseIcon from '@mui/icons-material/Close';
import List from '@mui/material/List';
import ListItem from '@mui/material/ListItem';
import { Link } from 'react-router-dom';
import { Toolbar } from '@mui/material';


export const StyledMainContent = styled('div')(({ theme }) => ({
  color: theme.palette.text.primary,
  backgroundColor: theme.palette.background.default,
  fontFamily: 'var(--app-font-stack)',
}));


/**
 * StyledHeader defines the main header style using Material-UI's styled API.
 * It adapts font size for smaller screens.
 */
export const StyledHeader = styled('div')(({ theme }) => ({
  color: theme.palette.primary.main,
  fontFamily: 'var(--app-font-stack)',
  fontSize: '2.5rem',
  fontWeight: 600,
  display: 'flex',
  flexDirection: 'column',
  '@media (max-width:600px)': {
    fontSize: theme.typography.h1['@media (max-width:600px)'].fontSize,
  },
}));

/**
 * StyledSubHeader defines the sub-header style, adapting for smaller screens.
 */
export const StyledSubHeader = styled('h2')(({ theme }) => ({
  color: theme.palette.primary.main,
  fontSize: theme.typography.h2.fontSize,
  fontWeight: theme.typography.h2.fontWeight,
  lineHeight: theme.typography.h2.lineHeight,
  '@media (max-width:600px)': {
    fontSize: theme.typography.h2['@media (max-width:600px)'].fontSize,
  },
}));


/**
 * StyledBox provides a styled container for general-purpose use, particularly suitable for UserList.js.
 * It offers consistent padding, background color, and responsive design.
 */
export const StyledBox = styled(Box)(({ theme }) => ({
  backgroundColor: theme.palette.background.paper,
  padding: theme.spacing(3),
  borderRadius: theme.shape.borderRadius,
  boxShadow: theme.shadows[1],
  margin: theme.spacing(2, 0),
  '@media (max-width:600px)': {
    padding: theme.spacing(2),
    margin: theme.spacing(1, 0),
  },
}));


/**
 * StyledSubSection provides a styled container for subsections within the application.
 * It uses custom styles defined in @custom.scss for consistent theming and responsive design.
 */
export const StyledSubSection = styled('div')(({ theme }) => ({
  backgroundColor: theme.palette.background.paper,
  padding: theme.spacing(2),
  borderRadius: theme.shape.borderRadius,
  boxShadow: theme.shadows[1],
  margin: theme.spacing(2, 0),
  '@media (max-width:768px)': {
    padding: theme.spacing(1),
    margin: theme.spacing(1, 0),
  },
  '.subsection-title': {
    fontSize: theme.typography.h6.fontSize,
    color: theme.palette.text.primary,
    marginBottom: theme.spacing(1),
  },
  '.subsection-content': {
    fontSize: theme.typography.body1.fontSize,
    color: theme.palette.text.secondary,
  },
}));

export const StyledList = styled(List)(({ theme }) => ({
  backgroundColor: theme.palette.background.paper,
  boxShadow: theme.shadows[1],
  borderRadius: theme.shape.borderRadius,
  overflow: 'hidden',
}));

export const StyledListItem = styled(ListItem)(({ theme }) => ({
  borderBottom: `1px solid ${theme.palette.divider}`,
  '&:last-child': {
    borderBottom: 'none',
  },
  '&:hover': {
    backgroundColor: theme.palette.action.hover,
  },
  '& strong': {
    marginRight: '0.5em', // Add right margin to strong tags within list items
  },
}));


export const StyledLink = styled(Link)(({ theme }) => ({
  color: theme.palette.primary.main,
  textDecoration: 'none',
  '&:hover': {
    color: theme.palette.primary.dark,
  },
}));


export const StyledParagraph = styled('p')(({ theme }) => ({
  color: theme.palette.text.secondary,
  fontSize: theme.typography.body1.fontSize,
  fontWeight: theme.typography.body1.fontWeight,
}));
export const StyledButton = styled(Button)(({ theme }) => ({
  
  textTransform: theme.typography.button.textTransform,
  borderRadius: theme.shape.borderRadius,
  padding: theme.spacing(1.5, 2),
  color: theme.palette.primary.contrastText,
  backgroundColor: theme.palette.primary.main,
  boxShadow: theme.shadows[2],
  marginLeft: theme.spacing(1.5),
  marginRight: theme.spacing(1.5),
  '&:hover': {
    backgroundColor: theme.palette.primary.dark,
    boxShadow: theme.shadows[4],
  },
}));

export const StyledIconButton = styled(IconButton)(({ theme }) => ({
  padding: theme.components.MuiIconButton.styleOverrides.root.padding,
  color: theme.palette.primary.main,
  backgroundColor: theme.palette.background.paper,
  boxShadow: '0px 2px 4px rgba(0, 0, 0, 0.2)',
  borderRadius: '50%',
  margin: theme.spacing(1),
  '&:hover': {
    backgroundColor: theme.palette.grey[300],
    boxShadow: '0px 4px 8px rgba(0, 0, 0, 0.3)',
  },
}));

export const StyledNegativeButton = styled(Button)(({ theme }) => ({
  textTransform: theme.typography.button.textTransform,
  borderRadius: theme.shape.borderRadius,
  padding: theme.spacing(1.5, 2),
  color: theme.palette.error.contrastText,
  backgroundColor: theme.palette.error.main,
  boxShadow: theme.shadows[2],
  marginLeft: theme.spacing(1.5),
  marginRight: theme.spacing(1.5),
  '&:hover': {
    backgroundColor: theme.palette.error.dark,
    boxShadow: theme.shadows[4],
  },
}));

export const StyledCloseButton = styled(CloseIcon)(({ theme }) => ({
  fontSize: '1.5rem',
  color: theme.palette.error.main,
  '&:hover': {
    color: theme.palette.error.dark,
  },
}));

export const StyledCheckbox = styled(Checkbox)(({ theme }) => ({
  color: theme.components.MuiCheckbox.styleOverrides.root.color,
  '&.Mui-checked': {
    color: theme.components.MuiCheckbox.styleOverrides.root['&.Mui-checked'].color,
  },
}));

export const StyledFormControlLabel = styled(FormControlLabel)(({ theme }) => ({
  color: theme.palette.text.primary,
  '& .MuiFormControlLabel-label': {
    fontSize: theme.typography.body1.fontSize,
    fontWeight: theme.typography.fontWeightMedium,
    marginLeft: theme.spacing(1),
  },
  '& .MuiTypography-root': {
    margin: theme.spacing(1),
  },
}));

export const StyledTable = styled(Table)(({ theme }) => ({
  backgroundColor: theme.palette.background.paper,
  '& .MuiTableRow-root': {
    '&:nth-of-type(odd)': {
      backgroundColor: theme.palette.action.hover,
    },
    '&:hover': {
      backgroundColor: theme.palette.action.selected,
    },
  },
  tableLayout: 'auto',
}));

export const StyledTableBody = styled(TableBody)(({ theme }) => ({
  backgroundColor: theme.palette.background.paper,
}));


export const StyledTableRow = styled(TableRow)(({ theme }) => ({
  '&:nth-of-type(odd)': {
    backgroundColor: theme.palette.action.hover,
  },
  '&:hover': {
    backgroundColor: theme.palette.action.selected,
  },
}));

export const FixedStyledTable = styled(StyledTable)(({ theme }) => ({
  maxWidth: '1200px',
  width: '100%',
  overflowX: 'auto',
}));


export const StyledTableHead = styled(TableHead)(({ theme }) => ({
  backgroundColor: theme.palette.background.default,
}));


export const StyledTableCell = styled(TableCell)(({ theme }) => ({
  fontWeight: theme.typography.fontWeightMedium,
  color: theme.palette.text.secondary,
  whiteSpace: 'nowrap',
  overflow: 'hidden',
  textOverflow: 'ellipsis',
}));

export const StyledNegativeTableCell = styled(TableCell)(({ theme }) => ({
  fontWeight: theme.typography.fontWeightMedium,
  color: theme.palette.error.main, // Use the error color for negative/warning actions like delete
  whiteSpace: 'nowrap',
  overflow: 'hidden',
  textOverflow: 'ellipsis',
}));

export const FixedStyledTableCell = styled(TableCell)(({ theme }) => ({
  whiteSpace: 'nowrap',
  maxWidth: '1px',
  overflow: 'hidden',
  textOverflow: 'ellipsis',
}));

export const WrappedTextDescStyledDiv = styled('div')(({ theme }) => ({
  whiteSpace: 'normal',
  maxHeight: '200px',
  overflow: 'auto',
  textOverflow: 'clip',
}));

export const DescStyledDiv = styled('div')(({ theme }) => ({
  whiteSpace: 'nowrap',
  maxHeight: '200px',
  overflow: 'hidden',
  textOverflow: 'ellipsis',
}));

export const StyledTooltipText = styled('span')(({ theme }) => ({
  display: 'block', // Changed from inline-block to block
  backgroundColor: theme.palette.background.default,
  color: theme.palette.text.primary,
  padding: theme.spacing(1),
  borderRadius: theme.shape.borderRadius,
  boxShadow: theme.shadows[1],
  fontSize: theme.typography.pxToRem(12),
  width: '100%', // Set width to 100% to fill the container
  boxSizing: 'border-box', // Ensure padding is included in the width
  wordWrap: 'break-word',
}));



export const StyledModal = styled(Modal)(({ theme }) => ({
  backgroundColor: theme.components.MuiModal.styleOverrides.paper.backgroundColor,
  boxShadow: theme.components.MuiModal.styleOverrides.paper.boxShadow,
  margin: 'auto', // Center the modal on the page horizontally
  width: 'fit-content', // Let the modal width grow as needed
  maxHeight: 'min-content', // Prevent the modal from being taller than the viewport height minus some margin
  overflowY: 'auto', // Allow vertical scrolling within the modal
  maxWidth: '80vw',
  display: 'flex',
  alignItems: 'center',
  justifyContent: 'center',
  zIndex: 100,
}));

// Add a styled component for the floating window
export const StyledFloatingWindow = styled('div')(({ theme }) => ({
  position: 'fixed',
  top: '70px',
  right: '10px',
  zIndex: 1000,
  backgroundColor: theme.palette.background.paper,
  boxShadow: theme.shadows[5],
  borderRadius: theme.shape.borderRadius,
  padding: theme.spacing(2),
  maxHeight: 'calc(100vh - 80px)',
  overflowY: 'auto',
}));

// This should be the container within the modal that you want to have the shadow
export const StyledModalContent = styled('div')(({ theme }) => ({
    backgroundColor: theme.palette.background.paper,
    boxShadow: '0px 8px 16px rgba(0, 0, 0, 0.2)', // Example shadow
    padding: theme.spacing(2), // Add some padding inside the container
    borderRadius: theme.shape.borderRadius, // Optional: if you want rounded corners
    overflowY: 'auto', // Add vertical scroll
    maxHeight: '80vh', // Set a maximum height
}));

export const StyledDownloadStatusModal = styled(Modal)(({ theme }) => ({
  backgroundColor: theme.components.MuiModal.styleOverrides.paper.backgroundColor,
  boxShadow: theme.components.MuiModal.styleOverrides.paper.boxShadow,
  margin: 'auto', // Center the modal on the page horizontally
  width: 'fit-content', // Let the modal width grow as needed
  maxHeight: 'min-content', // Prevent the modal from being taller than the viewport height minus some margin
  overflowY: 'auto', // Allow vertical scrolling within the modal
  maxWidth: '80vw',
  display: 'flex',
  alignItems: 'center',
  justifyContent: 'center',
  zIndex: 100,
}));

export const StyledConfirmModal = styled(Modal)(({ theme }) => ({
  backgroundColor: theme.components.MuiModal.styleOverrides.paper.backgroundColor,
  boxShadow: theme.components.MuiModal.styleOverrides.paper.boxShadow,
  margin: 'auto', // Center the modal on the page horizontally
  width: 'fit-content', // Let the modal width grow as needed
  maxHeight: 'min-content', // Prevent the modal from being taller than the viewport height minus some margin
  overflowY: 'auto', // Allow vertical scrolling within the modal
  maxWidth: '80vw',
  display: 'flex',
  alignItems: 'center',
  justifyContent: 'center',
  zIndex: 100,
}));

// This should be the container within the modal that you want to have the shadow
export const StyledDownloadStatusModalContent = styled('div')(({ theme }) => ({
    backgroundColor: theme.palette.background.paper,
    boxShadow: '0px 8px 16px rgba(0, 0, 0, 0.2)', // Example shadow
    padding: theme.spacing(2), // Add some padding inside the container
    borderRadius: theme.shape.borderRadius, // Optional: if you want rounded corners
    display: 'flex',
    flexDirection: 'column',
    alignItems: 'flex-start',
    justifyContent: 'flex-start',
    overflowY: 'auto',
    maxHeight: '60vh',
}));

export const StyledDownloadStatusItem = styled('div')(({ theme }) => ({
    display: 'flex',
    flexDirection: 'column',
    alignItems: 'flex-start',
    justifyContent: 'flex-start',
    padding: theme.spacing(1),
    borderBottom: `1px solid ${theme.palette.divider}`,
    width: '100%',
}));

export const StyledDownloadStatusText = styled(Typography)(({ theme }) => ({
    color: theme.palette.text.primary,
    overflow: 'hidden',
    textOverflow: 'ellipsis',
    whiteSpace: 'nowrap',
}));

export const StyledDownloadProgressBar = styled(LinearProgress)(({ theme }) => ({
    width: '100%',
    margin: theme.spacing(1, 0),
}));

export const StyledCircularProgress = styled(CircularProgress)(({ theme }) => ({
  color: theme.components.MuiCircularProgress.styleOverrides.root.color,
}));

export const StyledSlider = styled(Slider)(({ theme }) => ({
  color: theme.palette.primary.main,
  '& .MuiSlider-thumb': {
    backgroundColor: theme.palette.accent.main,
  },
  '& .MuiSlider-track': {
    backgroundColor: theme.palette.secondary.main,
  },
  '& .MuiSlider-rail': {
    backgroundColor: theme.palette.text.secondary,
  },
}));

export const StyledSwitch = styled(Switch)(({ theme }) => ({
  '& .MuiSwitch-switchBase': {
    color: theme.palette.primary.main,
  },
  '& .MuiSwitch-switchBase.Mui-checked': {
    color: theme.palette.accent.main,
  },
  '& .MuiSwitch-track': {
    backgroundColor: theme.palette.background.default,
  },
}));

export const CustomTextField = styled(TextField)(({ theme }) => ({
  '& .MuiInputBase-root': {
    color: theme.palette.text.primary,
    backgroundColor: theme.palette.background.paper,
  },
  '& .MuiInput-underline:before': {
    borderBottomColor: theme.palette.divider,
  },
  // ...other styles
}));

export const StyledTextField = (props) => (
  <CustomTextField {...props} autoComplete="off" />
);

export const StyledInactiveText = styled('li')(({ theme }) => ({
  color: theme.palette.text.disabled, // Use the theme's disabled text color for inactive elements
  fontStyle: 'italic', // Italicize to indicate inactivity or historical status
}));

export const StyledCollapseButton = styled('button')(({ theme }) => ({
    background: 'none',
    border: 'none',
    cursor: 'pointer',
    fontSize: '1em',
    marginLeft: '10px',
}));

export const StyledHeaderToolbar = styled(Toolbar)(({ theme }) => ({
  display: 'flex',
  justifyContent: 'space-between',
  alignItems: 'center',
  padding: theme.spacing(1, 2),
}));

export const StyledLogoBox = styled(Box)(({ theme }) => ({
  display: 'flex',
  alignItems: 'center',
  flexGrow: 1,
}));
