# App Garden Preview Images

This directory contains preview images for App Garden applications, served directly by the frontend.

## Image Specifications

### Required Dimensions
- **Size**: 320x180 pixels (16:9 aspect ratio)
- **Format**: PNG (preferred), JPG, or WebP
- **File size**: Keep under 100KB for optimal loading

## How Images Are Displayed

Images are displayed in responsive cards with:
- Fixed height of 180px
- Width that adapts to grid layout (25%, 33%, 50%, or 100% of container)
- `object-fit: cover` CSS property ensures images fill the container
- `object-position: center` keeps the focal point centered

## Naming Convention

Use lowercase with underscores, matching the app name:
- `hello_web.png` for the hello-web app
- `ai_chatbot.png` for the ai-chatbot app
- `kaizen.png` for the Kaizen app
- `shinobi_bench.png` for the Shinobi Bench app

## Adding New Images

1. Create your image at 320x180px (or 640x360px for high-res)
2. Optimize the image (use tools like TinyPNG or ImageOptim)
3. Place it in this directory (`/frontend/public/app-garden-images/`)
4. Reference in `apps.json` as: `"preview_image": "/app-garden-images/your_image.png"`

## Image Creation Tips

### Using ImageMagick to Resize
```bash
# Resize and crop to exact 320x180, centered
magick input.png -resize 320x180^ -gravity center -extent 320x180 output.png

### Design Guidelines
- Use clear, high-contrast visuals
- Include app logo or distinctive UI elements
- Avoid too much text (it won't be readable at this size)
- Consider dark mode compatibility (avoid pure white backgrounds)
- Use consistent visual style across all app images

## Production Deployment

For production, these images are:
1. Bundled with the frontend build
2. Served directly by the web server (nginx/node)
3. Cached by browsers and CDNs
4. No backend API calls required

## File Organization

```
frontend/public/app-garden-images/
├── README.md (this file)
├── hello_web.png
├── ai_chatbot.png
├── kaizen.png
└── ... (other app images)
```