const { spawn } = require('child_process');
const ps = require('ps-node');

process.title = 'kamiwaza-frontend';

const isProduction = process.env.KAMIWAZA_FRONTEND_ENV === 'production';
const command = isProduction ? 'npm run serve' : 'npm run start';

console.log(`Starting ${process.env.KAMIWAZA_FRONTEND_ENV} mode with command: ${command}`);

// Spawn the process
const child = spawn(command, {
  shell: true,
  stdio: 'inherit',
  env: {
    ...process.env,
    FORCE_COLOR: '1'
  }
});

child.on('exit', (code) => {
  if (code !== 0) {
    console.error(`Process exited with code ${code}`);
    process.exit(code);
  }
});

const cleanup = () => {
  child.kill('SIGTERM');
  setTimeout(() => {
    child.kill('SIGKILL');
  }, 5000);
};

process.on('SIGINT', cleanup);
process.on('SIGTERM', cleanup);