import js from "@eslint/js";
import globals from "globals";
import pluginReact from "eslint-plugin-react";

export default [
  {
    files: ["**/*.{js,mjs,cjs,jsx}"],
    languageOptions: {
      globals: {
        ...globals.browser,
        ...globals.jest,
        ...globals.node
      },
      ecmaVersion: "latest",
      sourceType: "module",
      parserOptions: {
        ecmaFeatures: {
          jsx: true
        }
      }
    },
    plugins: {
      react: pluginReact
    },
    rules: {
      ...js.configs.recommended.rules,
      ...pluginReact.configs.recommended.rules,
      "no-unused-vars": ["error", {
        "varsIgnorePattern": "^theme$",
        "argsIgnorePattern": "^theme$"
      }]
    },
    settings: {
      react: {
        version: "detect"
      }
    }
  },
  {
    files: ["**/*.test.js", "**/*.test.jsx", "**/setupTests.js"],
    languageOptions: {
      globals: {
        ...globals.browser,
        ...globals.jest,
        global: "readonly",
        afterEach: "readonly"
      }
    }
  }
];
