# ReBAC Policy Manifests

This directory stores declarative policy definitions used to validate ReBAC
tuples. Manifests follow the schema documented in
`docs-internal/topics/auth/rebac_policy_manifest.md`.

## Layout
- `configs/rebac/policies/default.yaml` – canonical policy for the `__default__`
  tenant (admin owns all datasets/models).
- `configs/rebac/policies/core.yaml` – template manifest showing how to embed
  `${TENANT_ID}` placeholders for additional tenants.
- `configs/rebac/tenants/` – bootstrap manifests for tuple seeding.

## Workflow
1. Add/update the YAML manifest under `configs/rebac/policies/`.
2. Run validation: `scripts/rebac_policy.py validate configs/rebac/policies`.
3. Capture the generated plan/diff in the PR description when policy changes
   add/remove tuples.
4. On merge, CI runs the same validation to gate regressions.

Note: `make pre-pr-checks` invokes the validator automatically for changed
policy files.

All manifests must be reviewed like code (policy changes require explicit
approval from the ReBAC owners).
