# Kamiwaza.AI

Welcome to the GitHub repository for Kamiwaza.AI, a powerful suite of AI tools and libraries. This repository contains a selection of our public libraries, which are designed to help you build and deploy AI models with ease. Please note that our core services are not publicly available. (This may change in the future!)

That said, please reach out at support@kamiwaza.ai if you are interested in being an early tester on our commmunity edition. We believe in Open Source and we are grateful for the amazing generosity of the AI community; as we progress toward 1.0 we hope to be able to open source much more of the code.

## Getting Started

Core requirements for Kamiwaza:

### Prerequisites

#### Kamiwaza Services
**Important Note**: if you are manually installing pre-requisites like npm/nvm we recommend doing so in a **bash** shell as things like the npm installer will bind to shell-specific startup scripts at times!

* Python 3.10.x (Tested on 3.10.14) & devel packages
  * Ubuntu: `sudo apt install -y python3.10 python3.10-dev libpython3.10-dev python3.10-venv python-is-python3 jq`
  * OSX: `brew install python@3.10`
* npm/nvm - tested on node-22.12.0, recommend `nvm install 22`
* uv (https://github.com/astral-sh/uv)
* Docker and Docker Compose
* Cockroach cli (`brew install cockroachdb/tap/cockroach` on OSX; [Cockroach Release Page](https://www.cockroachlabs.com/docs/releases/) for Linux) - full binary, as it is used to build certs
* cairo (`sudo apt install libcairo2-dev` on Ubuntu, `brew install cairo` on OSX)
* pygobject3 (`brew install pygobject3`)
* libgirepository (`sudo apt install libgirepository1.0-dev` on Ubuntu)
* golang-cfssl 
  * Ubuntu: `sudo apt install golang-cfssl`
  * OSX: `brew install cfssl`
* etcd client 
  * Ubuntu: `sudo apt install etcd-client`
  * OSX: `brew install etcd`
* net-tools 
  * Ubuntu: `sudo apt install net-tools`
  * OSX: Built-in
* jq
  * Ubuntu: (included up with 3.10.x) `sudo apt install -y jq`
  * OSX: `brew install jq`
* OS: OSX, Ubuntu 22.04 LTS (Note: Kamiwaza may work on any Linux flavor, but our fully supported version is Ubuntu 22.04 LTS server currently
* **Recommended**: Mac w/ Apple Silicon, or nVidia GPU - if using nVidia, CUDA 12.3+ is recommended currently

#### Notes on other Distros

While not yet, supported, a few notes:

* Fedora: `sudo dnf install cairo-devel`
* Fedora: `sudo dnf install cairo-gobject-devel`
* Fedora: `sudo dnf install python3-devel`
* Fedora: `sudo dnf install gobject-introspection-devel`

#### Kamiwaza Client Libraries

* uv (https://github.com/astral-sh/uv)
* Python 3.10.x (Tested on 3.10.14)


## Installing
```bash

tar -xvf kamiwaza*tar
bash install.sh

```

Should be all that's needed on a fresh install.

## Getting Started

We **strongly recommend** starting with a look at the Notebooks. There are a number of them, and they are designed to be run in order. They take you through a small but very interesting subset of Kamiwaza functionality. Obviously, click around the UI! (It can also be interesting to look around the UI between notebook runs.)

## Client-SDK

Starting in 0.3.2 there is a client sdk

`uv pip install kamiwaza`

[See the SDK documentation](https://docs.kamiwaza.ai/sdk/intro)

## Included Packages

For rapid "out of the box" usefulness, Kamiwaza installs a number of open source services. Our stack philosophy is:

"Opinionated, but loosely coupled."

These packages are:

* Acryl Datahub
* CockroachDB
* Milvus

CockroachDB is a mostly-postgres-compatible but very durable and scalable relational database and is used for holding backend data, specifically:

* Model repository info
* Cluster information (which includes node, location, and vectordb deployment info)
* Prompt database

Milvus is a vector database; we will have support for Weaviate (in progress), Qdrant (love them!), and Pinecone (SaaS only!) in the future (loosely coupled!)

Datahub is more tightly integrated at the moment. We will absolutely be supporting other catalog sources, such as Hive Metastore, Databricks Unity Catalog, etc, but we have to make decisions about whether Datahub is removable or whether we would use it only for metadata that other catalogs do NOT support.


```bash
make uv-sync
```

kw_py install.py

This will validate the existence of config files:
```
config_paths_to_check = [
    './kamiwaza/cluster/config.py',
    './kamiwaza/serving/config.py',
    './kamiwaza/node/config.py',
    './kamiwaza/services/catalog/config.py',
    './kamiwaza/services/vectordb/config.py',
    './kamiwaza/services/models/config.py',
    './kamiwaza/services/retrieval/config.py',
    './kamiwaza/services/prompts/config.py'
]
```
Run the `install.sh` script which will install the docker containers

And after they are up, it will initialize the databases.

If you encounter any issues, contact support@kamiwaza.ai

## Documentation

For more detailed information on how to use Kamiwaza.AI, please refer to our [official documentation](https://docs.kamiwaza.ai/).

(Note: This doesn't exist yet! But soon.)

## Contributing

We welcome contributions to our public libraries. If you're interested in contributing, please see our [contribution guidelines](https://kamiwaza.ai/contributing).

(Note: This doesn't exist yet! But soon.)

## License

Kamiwaza core is currently proprietary. However, see our [GitHub Repository](https://github.com/kamiwaza-ai/) for information about our open source libraries.

We recently released an early front-end Chat & Agent package, AgentZero, which has built-in compatibility with Kamiwaza's retrieval and model functions, allowing you to turn it up as a "Chat + Docs" that automatically works with deployed models and available datasets.

## Contact

If you have any questions or feedback, please feel free to contact us at [contact@kamiwaza.ai](mailto:contact@kamiwaza.ai).
